<?php

namespace App\Controllers;

use App\Libraries\CIAuth;
use App\Libraries\OneSignal;

use App\Models\PanelModel;
use App\Models\UsersModel;
use App\Models\NotificationModel;

class NotificationController extends BaseController {
    
    public function __construct(){
        $panelModel = new PanelModel();
        $this->settings = $panelModel->getSettings();
    }
    
    public function onesignal_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        if(CIAuth::adminType() == 2){
           return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Notification Onesignal',
            'currentFile' => 'notification_onesignal'
        ];
        $data['settings'] = $this->settings;
        
        return view('onesignal', $data);
    }
    
    public function onesignalHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        if(CIAuth::adminType() == 2){
           return redirect()->to(base_url('ns-admin'));
        }
        
        $YOUR_ONESIGNAL_APP_ID = $this->settings['onesignal_app_id'];
        $YOUR_ONESIGNAL_REST_API_KEY = $this->settings['onesignal_rest_key'];
        
        if(empty($YOUR_ONESIGNAL_APP_ID)){
            $message = array('message' => lang('Validation.notification_failed_id'),'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/notification-onesignal'));
        }
        
        if(empty($YOUR_ONESIGNAL_REST_API_KEY)){
            $message = array('message' => lang('Validation.notification_failed_key'),'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/notification-onesignal'));
        }
        
        $title = $this->request->getPost('notification_title');
        $titleSub = $this->request->getPost('notification_des');
        $msg = $this->request->getPost('notification_msg');
        
        $oneSignal = new OneSignal();
        $success = $oneSignal->sendNotification($YOUR_ONESIGNAL_APP_ID, $YOUR_ONESIGNAL_REST_API_KEY, $title, $msg);
        if ($success) {
            $message = array('message' => lang('Validation.notification_send'),'class' => 'success');
        } else {
            $message = array('message' => ang('Validation.notification_send_failed'),'class' => 'error');
        }
        session()->set('response_msg', $message);
        return redirect()->to(base_url('ns-admin/notification-onesignal'));
    }
    
    public function notifi_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        if(CIAuth::adminType() == 2){
           return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Notification send to a User',
            'currentFile' => 'notification_user',
            'pageSave' => 'Send'
        ];
        
        $users = new UsersModel();
        $data['usersResult'] = $users->orderBy('id', 'DESC')->findAll();
        
        $data['settings'] = $this->settings;
        
        return view('notification_user', $data);
    }
    
    public function notifiHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        if(CIAuth::adminType() == 2){
           return redirect()->to(base_url('ns-admin'));
        }
        
        $data = array(
            'user_id' => $this->request->getPost('user_id'),
            'notification_title' => $this->request->getPost('notification_title'),
            'notification_msg' => $this->request->getPost('notification_msg'),
            'notification_on' =>  strtotime(date('d-m-Y h:i:s A')) 
        );
        
        $users = new NotificationModel();
        $users->insert($data);
        
        $message = array('message' => lang('Validation.notification_send'),'class' => 'success');
        session()->set('response_msg', $message);
        return redirect()->to(base_url('ns-admin/notification-user'));
    }
}